/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;
import javax.microedition.midlet.MIDlet;

public class VideoMidlet
extends MIDlet
implements CommandListener,
PlayerListener,
Runnable {
    private static final String EXIT = "Exit";
    private static final String PAUSE = "Pause";
    private static final String PLAY = "Play";
    private Display display;
    private Form playerForm;
    private Thread thread;
    private Player player;
    private StringItem curStatus;
    private final Command cmdExit = new Command("Exit", 7, 2);
    private final Command cmdPause = new Command("Pause", 8, 1);
    private final Command cmdPlay = new Command("Play", 8, 1);

    public VideoMidlet() {
        this.display = Display.getDisplay((MIDlet)this);
        this.playerForm = new Form("MMAPI Video");
        this.initVideo();
        this.curStatus = new StringItem("Player Status:", "Reading Content");
        this.playerForm.append((Item)this.curStatus);
        this.playerForm.addCommand(this.cmdExit);
        this.playerForm.addCommand(this.cmdPause);
        this.playerForm.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        this.display.setCurrent((Displayable)this.playerForm);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.playerClose();
    }

    public void exitMidlet() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void initVideo() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        block3: {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/video.mpg");
                this.player = Manager.createPlayer((InputStream)inputStream, (String)"video/mpeg");
                this.player.realize();
                this.player.prefetch();
                this.player.addPlayerListener((PlayerListener)this);
                VideoControl videoControl = (VideoControl)this.player.getControl("VideoControl");
                if (videoControl != null) {
                    Item item = (Item)videoControl.initDisplayMode(0, null);
                    this.playerForm.append(item);
                }
            }
            catch (Exception exception) {
                if (this.player == null) break block3;
                this.player.close();
                this.player = null;
            }
        }
        this.startPlayer();
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (string == "started") {
            this.curStatus.setText("Started Playing Audio");
        } else if (string == "stopped") {
            this.curStatus.setText("Stopped Playing Audio");
        } else if (string == "closed") {
            this.curStatus.setText("Closed Playing Audio");
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdPause && displayable == this.playerForm) {
            this.playerPause();
            this.playerForm.removeCommand(this.cmdPause);
            this.playerForm.addCommand(this.cmdPlay);
        } else if (command == this.cmdExit && displayable == this.playerForm) {
            this.exitMidlet();
        } else if (command == this.cmdPlay && displayable == this.playerForm) {
            this.playerForm.removeCommand(this.cmdPlay);
            this.playerForm.addCommand(this.cmdPause);
            this.startPlayer();
        }
    }

    public void startPlayer() {
        if (this.player != null) {
            try {
                this.player.start();
            }
            catch (MediaException mediaException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void playerPause() {
        if (this.player != null) {
            try {
                this.player.stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerClose() {
        VideoMidlet videoMidlet = this;
        synchronized (videoMidlet) {
            this.playerPause();
            if (this.player != null) {
                this.player.close();
                this.player = null;
            }
        }
    }
}

