/*
 * Decompiled with CFR 0.152.
 */
package example.mms;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.PushRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import javax.wireless.messaging.MessagePart;
import javax.wireless.messaging.MultipartMessage;

public class MMSReceive
extends MIDlet
implements CommandListener,
Runnable,
MessageListener {
    private static final Command CMD_EXIT = new Command("Exit", 7, 2);
    private Form content;
    private Display display;
    private Thread thread;
    private String[] connections;
    private boolean done;
    private String appID = this.getAppProperty("MMS-ApplicationID");
    private MessageConnection mmsconn;
    private Message msg;
    private String senderAddress;
    private Alert sendingMessageAlert;
    private Displayable resumeScreen;
    private String subject;
    private String contents;

    public MMSReceive() {
        this.display = Display.getDisplay((MIDlet)this);
        this.content = new Form("MMS Receive");
        this.content.addCommand(CMD_EXIT);
        this.content.setCommandListener((CommandListener)this);
        this.content.append("Receiving...");
        this.sendingMessageAlert = new Alert("MMS", null, null, AlertType.INFO);
        this.sendingMessageAlert.setTimeout(5000);
        this.sendingMessageAlert.setCommandListener((CommandListener)this);
        this.resumeScreen = this.content;
    }

    public void startApp() {
        this.display.setCurrent(this.resumeScreen);
        String string = "mms://:" + this.appID;
        if (this.mmsconn == null) {
            try {
                this.mmsconn = (MessageConnection)Connector.open((String)string);
                this.mmsconn.setMessageListener((MessageListener)this);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.connections = PushRegistry.listConnections((boolean)true);
        if (this.connections == null || this.connections.length == 0) {
            this.content.deleteAll();
            this.content.append("Waiting for MMS on applicationID " + this.appID + "...");
        }
        this.done = false;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void notifyIncomingMessage(MessageConnection messageConnection) {
        if (this.thread == null && !this.done) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void run() {
        try {
            this.msg = this.mmsconn.receive();
            if (this.msg != null) {
                this.senderAddress = this.msg.getAddress();
                this.content.deleteAll();
                String string = this.senderAddress.substring(6);
                int n = string.indexOf(":");
                if (n != -1) {
                    string = string.substring(0, n);
                }
                this.content.setTitle("From: " + string);
                if (this.msg instanceof MultipartMessage) {
                    MultipartMessage multipartMessage = (MultipartMessage)this.msg;
                    StringBuffer stringBuffer = new StringBuffer("Subject: ");
                    this.subject = multipartMessage.getSubject();
                    stringBuffer.append(this.subject);
                    if (multipartMessage.getTimestamp() != null) {
                        stringBuffer.append("\nDate: ");
                        stringBuffer.append(((Object)multipartMessage.getTimestamp()).toString());
                    }
                    stringBuffer.append("\nContent:");
                    StringItem stringItem = new StringItem("Message", stringBuffer.toString());
                    stringItem.setLayout(512);
                    this.content.append((Item)stringItem);
                    MessagePart[] messagePartArray = multipartMessage.getMessageParts();
                    if (messagePartArray != null) {
                        for (int i = 0; i < messagePartArray.length; ++i) {
                            StringItem stringItem2;
                            stringBuffer = new StringBuffer();
                            MessagePart messagePart = messagePartArray[i];
                            stringBuffer.append("Content-Type: ");
                            String string2 = messagePart.getMIMEType();
                            stringBuffer.append(string2);
                            String string3 = messagePart.getContentLocation();
                            stringBuffer.append("\nContent:\n");
                            byte[] byArray = messagePart.getContent();
                            try {
                                Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                                this.content.append(stringBuffer.toString());
                                stringItem2 = new ImageItem(string3, image, 512, string3);
                                this.content.append((Item)stringItem2);
                                continue;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                stringBuffer.append(new String(byArray));
                                stringItem2 = new StringItem("Part", stringBuffer.toString());
                                stringItem2.setLayout(512);
                                this.content.append((Item)stringItem2);
                            }
                        }
                    }
                }
                this.display.setCurrent((Displayable)this.content);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void pauseApp() {
        this.done = true;
        this.thread = null;
        this.resumeScreen = this.display.getCurrent();
    }

    public void destroyApp(boolean bl) {
        this.done = true;
        this.thread = null;
        if (this.mmsconn != null) {
            try {
                this.mmsconn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command == CMD_EXIT) {
                this.destroyApp(false);
                this.notifyDestroyed();
            } else if (command == Alert.DISMISS_COMMAND) {
                this.startApp();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

