/*
 * Decompiled with CFR 0.152.
 */
package example.mms;

import example.mms.MMSSend;
import java.io.InputStream;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.wireless.messaging.MessagePart;

public class PartsDialog
implements CommandListener {
    private static final Command CMD_BACK = new Command("Back", 2, 1);
    private static final Command CMD_NEXT = new Command("Next", 4, 1);
    private static final Command CMD_OK = new Command("OK", 4, 1);
    private static final Command CMD_CANCEL = new Command("Cancel", 3, 1);
    private MMSSend mmsSend;
    private List typeList;
    public int counter = 0;

    public PartsDialog(MMSSend mMSSend) {
        this.mmsSend = mMSSend;
        String[] stringArray = new String[]{"Text", "Image"};
        this.typeList = new List("Add Part: Type", 1, stringArray, null);
        this.typeList.addCommand(CMD_BACK);
        this.typeList.addCommand(CMD_NEXT);
        this.typeList.setCommandListener((CommandListener)this);
    }

    public void show() {
        this.mmsSend.getDisplay().setCurrent((Displayable)this.typeList);
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command == CMD_BACK) {
                this.mmsSend.show();
            } else if (command == CMD_NEXT) {
                if (this.typeList.getSelectedIndex() == 0) {
                    this.mmsSend.getDisplay().setCurrent((Displayable)new TextDialog());
                } else {
                    this.mmsSend.getDisplay().setCurrent((Displayable)new ImageDialog());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class ImageDialog
    extends Form
    implements CommandListener {
        private Displayable mainForm;
        private ChoiceGroup cg;
        private String mimeType = "image/png";
        private String[] resouces = new String[]{"/Java.png", "/Duke.png"};
        private String[] imagesNames = new String[]{"Java", "Duke"};

        public ImageDialog() {
            super("Add Image");
            this.cg = new ChoiceGroup("Select Image", 1, this.imagesNames, null);
            this.append((Item)this.cg);
            this.append("MIME-Type: " + this.mimeType);
            this.addCommand(CMD_OK);
            this.addCommand(CMD_CANCEL);
            this.setCommandListener(this);
        }

        public void commandAction(Command command, Displayable displayable) {
            try {
                if (command == CMD_OK) {
                    int n = this.cg.getSelectedIndex();
                    String string = this.resouces[n];
                    InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string);
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    String string2 = this.imagesNames[n];
                    PartsDialog.this.mmsSend.getMessage().addPart(new MessagePart(byArray, 0, byArray.length, this.mimeType, "id" + PartsDialog.this.counter, string2, null));
                    ++PartsDialog.this.counter;
                    PartsDialog.this.mmsSend.show();
                } else if (command == CMD_CANCEL) {
                    PartsDialog.this.mmsSend.show();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class TextDialog
    extends Form
    implements CommandListener {
        private Displayable mainForm;
        private TextField text = new TextField("Text: ", null, 256, 0);
        private String mimeType = "text/plain";

        public TextDialog() {
            super("Add Text");
            this.append((Item)this.text);
            this.append("MIME-Type: " + this.mimeType);
            this.addCommand(CMD_OK);
            this.addCommand(CMD_CANCEL);
            this.setCommandListener(this);
        }

        public void commandAction(Command command, Displayable displayable) {
            try {
                if (command == CMD_OK) {
                    String string = "UTF-8";
                    byte[] byArray = this.text.getString().getBytes(string);
                    PartsDialog.this.mmsSend.getMessage().addPart(new MessagePart(byArray, 0, byArray.length, this.mimeType, "id" + PartsDialog.this.counter, "contentLocation", string));
                    ++PartsDialog.this.counter;
                    PartsDialog.this.mmsSend.show();
                } else if (command == CMD_CANCEL) {
                    PartsDialog.this.mmsSend.show();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

