/*
 * Decompiled with CFR 0.152.
 */
package example.sms;

import example.sms.SMSSender;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class SMSSend
extends MIDlet
implements CommandListener {
    Command exitCommand = new Command("Exit", 7, 2);
    Command okCommand = new Command("OK", 4, 1);
    Display display;
    String smsPort = this.getAppProperty("SMS-Port");
    TextBox destinationAddressBox;
    Alert errorMessageAlert;
    Alert sendingMessageAlert;
    SMSSender sender;
    Displayable resumeScreen = null;

    public SMSSend() {
        this.display = Display.getDisplay((MIDlet)this);
        this.destinationAddressBox = new TextBox("Destination Address?", null, 256, 3);
        this.destinationAddressBox.addCommand(this.exitCommand);
        this.destinationAddressBox.addCommand(this.okCommand);
        this.destinationAddressBox.setCommandListener((CommandListener)this);
        this.errorMessageAlert = new Alert("SMS", null, null, AlertType.ERROR);
        this.errorMessageAlert.setTimeout(5000);
        this.sendingMessageAlert = new Alert("SMS", null, null, AlertType.INFO);
        this.sendingMessageAlert.setTimeout(5000);
        this.sendingMessageAlert.setCommandListener((CommandListener)this);
        this.sender = new SMSSender(this.smsPort, this.display, (Displayable)this.destinationAddressBox, (Displayable)this.sendingMessageAlert);
        this.resumeScreen = this.destinationAddressBox;
        this.display.setCurrent(this.resumeScreen);
    }

    public void startApp() {
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command == this.exitCommand) {
                this.destroyApp(false);
                this.notifyDestroyed();
            } else if (command == Alert.DISMISS_COMMAND) {
                this.display.setCurrent(this.resumeScreen);
            } else if (command == this.okCommand) {
                this.promptAndSend();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void promptAndSend() {
        String string = this.destinationAddressBox.getString();
        if (!SMSSend.isValidPhoneNumber(string)) {
            this.errorMessageAlert.setString("Invalid phone number");
            this.display.setCurrent(this.errorMessageAlert, (Displayable)this.destinationAddressBox);
            return;
        }
        String string2 = "Sending message to " + string + "...";
        this.sendingMessageAlert.setString(string2);
        this.sender.promptAndSend("sms://" + string);
    }

    private static boolean isValidPhoneNumber(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length == 0) {
            return false;
        }
        int n = 0;
        if (cArray[0] == '+') {
            n = 1;
        }
        for (int i = n; i < cArray.length; ++i) {
            if (Character.isDigit(cArray[i])) continue;
            return false;
        }
        return true;
    }
}

