#!/sbin/busybox sh
#
# Filsystem Conversion Script for Samsung Apollo
# (c) 2012 by Teamhacksung
#

check_mount() {
    if ! /sbin/busybox grep -q $1 /proc/mounts ; then
        /sbin/busybox mkdir -p $1
        /sbin/busybox umount -l $2
        if ! /sbin/busybox mount -t $3 $2 $1 ; then
            /sbin/busybox echo "Cannot mount $1."
            exit 1
        fi
fi
}

set_log() {
    rm -rf $1
    exec >> $1 2>&1
}

set -x

export PATH=/:/sbin:/tmp:/system/bin:$PATH

# check if we're running on a bml or mtd device
if /sbin/busybox test -e /dev/block/bml10 ; then
    # we're running on a bml device

    export PATH=/tmp

    # make sure sdcard is mounted
    check_mount /mnt/sdcard /dev/block/mmcblk0p1 vfat

    # everything is logged into /mnt/sdcard/cyanogenmod_bml.log
    set_log /mnt/sdcard/cyanogenmod_bml.log

    # make sure efs is mounted
    check_mount /efs /dev/block/stl4 rfs

    # create a backup of efs
    if /sbin/busybox test -e /mnt/sdcard/backup/efs ; then
        /sbin/busybox mv /mnt/sdcard/backup/efs /mnt/sdcard/backup/efs-$$
    fi
    /sbin/busybox rm -rf /mnt/sdcard/backup/efs

    /sbin/busybox mkdir -p /mnt/sdcard/backup/efs
    /sbin/busybox cp -R /efs/ /mnt/sdcard/backup

    # Backup radio image
    /sbin/busybox dd if=/dev/block/bml10 of=/mnt/sdcard/backup/efs/modem.bin

    # write the package path to sdcard cyanogenmod.cfg
    if /sbin/busybox test -n "$UPDATE_PACKAGE" ; then
PACKAGE_LOCATION=${UPDATE_PACKAGE#/mnt}
        /sbin/busybox echo "--update_package=$PACKAGE_LOCATION" > /mnt/sdcard/cyanogenmod.cfg
    fi

    # write new kernel to boot partition
    /sbin/bmlunlock
    /sbin/busybox dd if=/tmp/boot.img of=/dev/block/bml5 bs=4096

    /sbin/busybox sync

    /sbin/reboot recovery
    exit 0

elif /sbin/busybox test -e /dev/block/mtdblock0 ; then
    # we're running on a mtd device

    # make sure sdcard is mounted
    check_mount /sdcard /dev/block/mmcblk0p1 vfat

    # everything is logged into /sdcard/cyanogenmod.log
    set_log /sdcard/cyanogenmod_mtd.log

    if ! /sbin/busybox test -e /sdcard/cyanogenmod.cfg ; then
        # update install - flash boot image then skip back to updater-script
        # (boot image is already flashed for first time install or old mtd upgrade)

        # flash boot image
        /sbin/bml_over_mtd.sh boot 40 reservoir 2004 /tmp/boot.img

# unmount system (recovery seems to expect system to be unmounted)
/sbin/busybox umount -l /system

        exit 0
    fi

    # if a cyanogenmod.cfg exists, then this is a first time install
    # let's format the volumes and restore radio and efs

    # remove the cyanogenmod.cfg to prevent this from looping
    /sbin/busybox rm -f /sdcard/cyanogenmod.cfg

    # unmount and format system (recovery seems to expect system to be unmounted)
    /sbin/busybox umount -l /system
    /sbin/erase_image system

    # unmount and format data
    /sbin/busybox umount /data
    /sbin/erase_image userdata

    # format cache
    /sbin/erase_image cache

    # restart into recovery so the user can install further packages before booting
    /sbin/busybox touch /cache/.startrecovery

    # restore efs backup
    if /sbin/busybox test -e /sdcard/backup/efs/modem.bin ; then
        /sbin/busybox umount -l /efs
        /sbin/erase_image efs
        /sbin/busybox mkdir -p /efs

        if ! /sbin/busybox grep -q /efs /proc/mounts ; then
if ! /sbin/busybox mount -t yaffs2 /dev/block/mtdblock4 /efs ; then
                /sbin/busybox echo "Cannot mount efs."
                exit 6
            fi
fi

        /sbin/busybox cp -R /sdcard/backup/efs /
        /sbin/busybox umount -l /efs
    else
        /sbin/busybox echo "Cannot restore efs."
        exit 7
    fi
exit 0
fi


