#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>


const char* header_str = "compress LZ";

int main( int argc, char** argv ) {
	unsigned char* rgb16_raw;
	unsigned char* code_seg;
	unsigned char* data_seg;
	unsigned char* code_ptr;
	unsigned char* data_ptr;
	unsigned char offset[4];
	unsigned char rgb24[3];
	int lz_dist, lz_count;
	int mode = 1; // 0 -> code, 1 -> data
	int npix = 0;
	int p, i, j;
	char tmp;
	
	
	#if defined( _WIN32 )				
		setmode( fileno( stdin ), O_BINARY );
		setmode( fileno( stdout ), O_BINARY );
	#endif
	
	
	fprintf( stderr, "processing image.... " );
	
	
	// convert and store in memory: 24 bit RAW (RGB, interleaved) to 16 bit RAW
	rgb16_raw = ( unsigned char* ) calloc( 1 << 16, 1 );
	while( fread( rgb24, 1, 3, stdin ) == 3 ) {
		rgb16_raw[(npix*2)+1] = ( ( rgb24[0] << 0 ) & 0xF8 ) | ( ( rgb24[1] >> 5 ) & 0x07 );
		rgb16_raw[(npix*2)+0] = ( ( rgb24[1] << 3 ) & 0xC0 ) | ( ( rgb24[2] >> 3 ) & 0x1F );
		if ( ((++npix)*2) % (1<<16) == 0 )
			rgb16_raw = ( unsigned char* ) realloc( rgb16_raw, (npix*2) + (1<<16) );
	}
	
	// alloc memory for code and data segments
	code_seg = ( unsigned char* ) calloc( (npix*2), 1 );
	data_seg = ( unsigned char* ) calloc( (npix*2), 1 );
	code_ptr = code_seg; data_ptr = data_seg;
	
	// main conversion loop
	for ( p = 0; p < npix; p++ ) {
		// find best match
		lz_dist = 0; lz_count = 0;
		for ( i = 1; i < (1<<11); i++ ) { // lz distance
			if ( i > p ) break;
			for ( j = 0; memcmp( rgb16_raw + ((p+j)*2), rgb16_raw + ((p+j-i)*2 ), 2 ) == 0; j++ ) 
				if ( ( j == (1<<4)-1 ) || ( (p+j) >= (npix-1) ) ) break; // lz count
			if ( lz_count < j ) {
				lz_dist = i;
				lz_count = j;
				if ( lz_count == (1<<4)-1 ) break;
			}
		}
		// write code / data segments
		if ( lz_count <= 1 ) { // no good match, copy image data to data segment
			*(data_ptr++) = rgb16_raw[(p*2)+0];
			*(data_ptr++) = rgb16_raw[(p*2)+1];
			if ( mode == 0 ) { // previous mode was LZ codes
				*(code_ptr-2) |= 0x08;
				mode = 1;
			}
		} else { // match found, generate code in code segment
			*(code_ptr++) = ( ( lz_count << 4 ) & 0xF0 ) | ( ( lz_dist >> 8 ) & 0x07 );
			*(code_ptr++) = ( lz_dist & 0xFF );
			if ( mode == 1 ) { // previous mode was data
				*(data_ptr-2) |= 0x20;
				mode = 0;
			}
			// advance pixel position
			p += lz_count - 1;
		}
	}
	// set last flag (data pointer)
	*(data_ptr-2) |= 0x20;
	
	// all pixels processed, calculate offset (offset total: 15 / 30 bit)
	offset[0] = ( ( code_ptr - code_seg ) & 0x0000FF00 ) >>  8;
	offset[1] = ( ( code_ptr - code_seg ) & 0x000000FE ) >>  0;
	if ( ( code_ptr - code_seg ) >= 1<<16 ) { // 4 byte offset
		offset[2] = ( ( code_ptr - code_seg ) & 0x00EF0000 ) >> 15;
		offset[3] = ( ( code_ptr - code_seg ) & 0x0EF10000 ) >> 23;
		offset[1] |= 1;
	}
	
	
	// write header ( 16 Byte )
	fwrite( header_str, 1, strlen( header_str ), stdout );
	for ( i = strlen( header_str ), tmp = 0x00; i < 16; i++ )
		fwrite( &tmp, 1, 1, stdout );

	// write offset ( 2/4 Byte )
	fwrite( offset, 1, ( offset[1] & 1 ) ? 4 : 2, stdout );
	
	// write code and data segments
	fwrite( code_seg, 1, code_ptr - code_seg, stdout );
	fwrite( data_seg, 1, data_ptr - data_seg, stdout );
	
	
	// summary
	fprintf( stderr, "\npixel count : %i pixels", npix );
	fprintf( stderr, "\ncode segment: %i byte", code_ptr - code_seg );
	fprintf( stderr, "\ndata segment: %i byte", data_ptr - data_seg );
	fprintf( stderr, "\ntotal size  : %i byte", (int) ftell( stdout ) );
	fprintf( stderr, "\ncomp. ratio : %.1f%%", ( (float) 100 * ftell( stdout ) ) / ( 2 * npix ) );
	fprintf( stderr, "\ndone!\n" );
	
	
	return 0;
}
